#include <allegro.h>

#include "actor.h"
#include "draw.h"
#include "sectors.h"
#include "man.h"
#include "alienship.h"
#include "tower.h"

float tower0_points[] = {
	   -74.437,     -4.652, // 0
	   160.505,     -2.326, // 1
	   160.505,    402.426, // 2
	   -72.111,    400.100, // 3
	   -53.502,    339.620, // 4
	   139.570,    348.924, // 5
	   -53.502,    225.638, // 6
	   137.244,    239.595, // 7
	   -46.523,    100.025, // 8
	   134.917,    116.308  // 9
};
int tower0_lines[] = {
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 0, 0, 0, 0,
	4, 5, 124, 188, 248,
	7, 6, 124, 188, 248,
	9, 8, 124, 188, 248 
};
float tower1_points[] = {
	   -74.437,     -4.652, // 0
	   160.505,     -2.326, // 1
	   295.423,    332.641, // 2
	    46.523,    146.548, // 3
	   160.505,    134.917, // 4
	   241.921,    272.161, // 5
	    16.283,     72.111, // 6
	   151.201,    193.071, // 7
	   -41.871,     23.262, // 8
	   118.634,     88.394  // 9
};
int tower1_lines[] = {
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 0, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	9, 8, 0, 0, 0 
};
float tower2_points[] = {
	   -74.437,     -4.652, // 0
	   160.505,     -2.326, // 1
	   260.530,    311.706, // 2
	    90.720,    109.330, // 3
	   116.308,      2.326, // 4
	   258.204,    297.749, // 5
	    60.480,     55.828, // 6
	   232.616,    262.856, // 7
	   -44.197,     -2.326, // 8
	   153.527,     90.720  // 9
};
int tower2_lines[] = {
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 0, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	9, 8, 0, 0, 0 
};
float tower3_points[] = {
	   -74.437,     -4.652, // 0
	   160.505,     -2.326, // 1
	   393.121,      2.326, // 2
	    90.720,    109.330, // 3
	   116.308,      2.326, // 4
	   246.573,     30.240, // 5
	    97.699,     81.416, // 6
	   358.229,      9.305, // 7
	   -44.197,     -2.326, // 8
	   162.831,    125.613  // 9
};
int tower3_lines[] = {
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 0, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	9, 8, 0, 0, 0 
};

void tower_process(int num)
{
	int remove = 0;
	ACTOR *actor = man[num];
	
	{
		float d = actor->x - alienship.x;
		if (d > SECTORS * SECTOR_DIMENSION / 2) {
			d -= SECTORS * SECTOR_DIMENSION;
		}
		if (d < -SECTORS * SECTOR_DIMENSION / 2) {
			d += SECTORS * SECTOR_DIMENSION;
		}
		if ( d > 3000 || d < -3000) {
			if (sector_place_man(actor)) remove = 1;
		}
	}
	
	if (actor->hit) {
		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame++;
			if (actor->frame == 5) actor->frame = 4;
		}
	}
	
	if (remove) {
		mans_num--;
		if (mans_num > 0) {
			man[num] = man[mans_num];
			man_process(num);
		}
	}
}

static void tower_draw(ACTOR *actor, int x, int y)
{
	if (actor->dx > 0) {
		if (actor->frame == 0) draw_(x, y, points(tower0), lines(tower0), tower0_points, tower0_points, tower0_lines, actor->anim / 16.0);
		if (actor->frame == 1) draw_(x, y, points(tower0), lines(tower0), tower0_points, tower1_points, tower0_lines, actor->anim / 16.0);
		if (actor->frame == 2) draw_(x, y, points(tower1), lines(tower1), tower1_points, tower2_points, tower1_lines, actor->anim / 16.0);
		if (actor->frame == 3) draw_(x, y, points(tower2), lines(tower2), tower2_points, tower3_points, tower2_lines, actor->anim / 16.0);
		if (actor->frame == 4) draw_(x, y, points(tower3), lines(tower3), tower3_points, tower3_points, tower3_lines, actor->anim / 16.0);
	}
	if (actor->dx < 0) {
		if (actor->frame == 0) m_draw_(x, y, points(tower0), lines(tower0), tower0_points, tower0_points, tower0_lines, actor->anim / 16.0);
		if (actor->frame == 1) m_draw_(x, y, points(tower0), lines(tower0), tower0_points, tower1_points, tower0_lines, actor->anim / 16.0);
		if (actor->frame == 2) m_draw_(x, y, points(tower1), lines(tower1), tower1_points, tower2_points, tower1_lines, actor->anim / 16.0);
		if (actor->frame == 3) m_draw_(x, y, points(tower2), lines(tower2), tower2_points, tower3_points, tower2_lines, actor->anim / 16.0);
		if (actor->frame == 4) m_draw_(x, y, points(tower3), lines(tower3), tower3_points, tower3_points, tower3_lines, actor->anim / 16.0);
	}
}

ACTOR *tower_init(void)
{
	static int gotcolor = 0;
	ACTOR *actor;
	if (mans_total == TOTAL_MANS) return NULL;
	actor = &(all_mans[mans_total]);
	actor_init(actor);
	bound_(points(tower0), tower0_points, &actor->l, &actor->t, &actor->r, &actor->b);
	if (!gotcolor) {
		color_(lines(tower0), tower0_lines);
		gotcolor = 1;
	}
	actor->draw = tower_draw;
	
	if ((rand() >> 8) & 1) actor->dx = 1; else {
		float t = actor->l;
		actor->dx = -1;
		actor->l = -actor->r;
		actor->r = -t;
	}
	
	actor->type = 3;
	
	mans_total++;
	return actor;
}
